CREATE TABLE [dbo].[TRANSFER_REQ]
(
[ACT_ID] [int] NOT NULL,
[ERA_ID] [int] NOT NULL,
[FACILITY_UID] [uniqueidentifier] NOT NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[DIAGNOSIS] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CURRENT_LOCATION] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[COMMENTS] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CONTRACT_ID] [int] NOT NULL,
[SPECIALITY_ID] [int] NOT NULL,
[LOCATION_ADMISSION_DATE] [datetime] NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__TRANSFER____ssis__73FA27A5] DEFAULT (getdate()),
[FACILITY_REGION] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FACILITY_VISN] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[REQUESTED_DATE] [datetime] NULL,
[ENTERED_BY] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LAST_EDIT_BY] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EDITED] [datetime] NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
IS_NATIONAL_WAIT_LIST BIT NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[TRANSFER_REQ_tgg_ssis_delete] on dbo.TRANSFER_REQ after delete as begin  delete [dbo].[TRANSFER_REQ_ssisdel] from [deleted] _xyz where [dbo].[TRANSFER_REQ_ssisdel].[ACT_ID]=[_xyz].[ACT_ID];  insert into [dbo].[TRANSFER_REQ_ssisdel]([ACT_ID], _ssis_timestamp)  select [ACT_ID], current_timestamp from [deleted];  end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[TRANSFER_REQ_tgg_ssis_insert] on dbo.TRANSFER_REQ after insert as begin delete [dbo].[TRANSFER_REQ_ssisdel]  from [inserted] _xyz where [dbo].[TRANSFER_REQ_ssisdel].[ACT_ID]=[_xyz].[ACT_ID] end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Transfer_Req_AfterDelete] 
   ON  [dbo].[TRANSFER_REQ] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Transfer_Req_H]
			     (ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, TRANSACTION_TYPE_CODE, DATE, CREATED_BY, IS_NATIONAL_WAIT_LIST)
			SELECT ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), IS_NATIONAL_WAIT_LIST
			FROM deleted;
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Transfer_Req_AfterInsert] 
   ON  [dbo].[TRANSFER_REQ] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Transfer_Req_H]
			   (ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, TRANSACTION_TYPE_CODE, DATE, CREATED_BY, IS_NATIONAL_WAIT_LIST)
			SELECT ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), IS_NATIONAL_WAIT_LIST
			FROM inserted;
    
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Transfer_Req_AfterUpdate] 
   ON  [dbo].[TRANSFER_REQ] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 INSERT INTO $(varBMS_HISTORY).[dbo].[Transfer_Req_H]
			 (ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID,  DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, TRANSACTION_TYPE_CODE, DATE, CREATED_BY, IS_NATIONAL_WAIT_LIST)
			SELECT ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID,  DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), IS_NATIONAL_WAIT_LIST
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Transfer_Req_InsteadOfInsert] 
   ON  [dbo].[TRANSFER_REQ]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[Transfer_Req]
			   (ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID,  DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, _ssis_timestamp, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, CREATED, CREATEDBY, IS_NATIONAL_WAIT_LIST)
			SELECT ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID,  DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, _ssis_timestamp, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE,REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), IS_NATIONAL_WAIT_LIST
			  FROM inserted;
	    
	
	ELSE
		INSERT INTO [dbo].[Transfer_Req]
			     (ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID,  DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, _ssis_timestamp, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, IS_NATIONAL_WAIT_LIST)
			SELECT ACT_ID, ERA_ID, FACILITY_UID, VISTA_SITE_UID, DIAGNOSIS, CURRENT_LOCATION, COMMENTS, CONTRACT_ID, SPECIALITY_ID, _ssis_timestamp, FACILITY_REGION, FACILITY_VISN, LOCATION_ADMISSION_DATE, REQUESTED_DATE, ENTERED_BY, LAST_EDIT_BY, EDITED, IS_NATIONAL_WAIT_LIST
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Transfer_Req_InsteadOfUpdate] 
   ON  [dbo].[TRANSFER_REQ] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[Transfer_Req]
		SET ERA_ID = inserted.ERA_ID,
			FACILITY_UID = inserted.FACILITY_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			DIAGNOSIS = inserted.DIAGNOSIS,
			CURRENT_LOCATION = inserted.CURRENT_LOCATION,
			COMMENTS = inserted.COMMENTS,
			CONTRACT_ID = inserted.CONTRACT_ID,
			SPECIALITY_ID = inserted.SPECIALITY_ID,
			FACILITY_REGION = inserted.FACILITY_REGION,
			FACILITY_VISN = inserted.FACILITY_VISN,
			LOCATION_ADMISSION_DATE = inserted.LOCATION_ADMISSION_DATE,
			REQUESTED_DATE = inserted.REQUESTED_DATE,
			ENTERED_BY = inserted.ENTERED_BY, 
			LAST_EDIT_BY = inserted.LAST_EDIT_BY, 
			EDITED = inserted.EDITED, 
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE(),
			IS_NATIONAL_WAIT_LIST = inserted.IS_NATIONAL_WAIT_LIST
		FROM [dbo].[Transfer_Req]
		INNER JOIN inserted ON inserted.act_id = [dbo].[Transfer_Req].act_id;
	 
	 ELSE
	    UPDATE [dbo].[Transfer_Req]
		SET ERA_ID = inserted.ERA_ID,
			FACILITY_UID = inserted.FACILITY_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			DIAGNOSIS = inserted.DIAGNOSIS,
			CURRENT_LOCATION = inserted.CURRENT_LOCATION,
			COMMENTS = inserted.COMMENTS,
			CONTRACT_ID = inserted.CONTRACT_ID,
			SPECIALITY_ID = inserted.SPECIALITY_ID,
			FACILITY_REGION = inserted.FACILITY_REGION,
			FACILITY_VISN = inserted.FACILITY_VISN,
			LOCATION_ADMISSION_DATE = inserted.LOCATION_ADMISSION_DATE,
			REQUESTED_DATE = inserted.REQUESTED_DATE,
			ENTERED_BY = inserted.ENTERED_BY, 
			LAST_EDIT_BY = inserted.LAST_EDIT_BY, 
			EDITED = inserted.EDITED,
		    _ssis_timestamp = current_timestamp,
			IS_NATIONAL_WAIT_LIST = inserted.IS_NATIONAL_WAIT_LIST
		FROM [dbo].[Transfer_Req]
		INNER JOIN inserted ON inserted.act_id = [dbo].[Transfer_Req].act_id;

END
GO

--Constraints
ALTER TABLE [dbo].[TRANSFER_REQ] ADD CONSTRAINT [PK_TRANSFER_REQ] PRIMARY KEY CLUSTERED  ([ACT_ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[TRANSFER_REQ] ADD CONSTRAINT [FK_TRANSFER_REQ_ACT] FOREIGN KEY ([ACT_ID]) REFERENCES [dbo].[ACT] ([ID])
GO
ALTER TABLE [dbo].[TRANSFER_REQ] ADD CONSTRAINT [FK_TRANSFER_REQ_CONCEPT_CONTRACT] FOREIGN KEY ([CONTRACT_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[TRANSFER_REQ] ADD CONSTRAINT [FK_TRANSFER_REQ_CONCEPT_ERA] FOREIGN KEY ([ERA_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[TRANSFER_REQ] ADD CONSTRAINT [FK_TRANSFER_REQ_CONCEPT_SPECIALTY] FOREIGN KEY ([SPECIALITY_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO


--Indexes
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[TRANSFER_REQ] ([_ssis_timestamp]) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_FACILITY_VISN_ERA] ON [dbo].[TRANSFER_REQ] 
(
	[FACILITY_UID] ASC,
	[CONTRACT_ID] ASC,
	[ERA_ID] ASC,
	[SPECIALITY_ID] ASC,
	[ACT_ID] ASC,
	[FACILITY_VISN] ASC
)
INCLUDE ( [DIAGNOSIS],
[CURRENT_LOCATION],
[COMMENTS],
[LOCATION_ADMISSION_DATE],
[IS_NATIONAL_WAIT_LIST]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE INDEX IDX_VISTA_SITE_UID_WITH_INCLUDE ON [dbo].[TRANSFER_REQ] ([VISTA_SITE_UID]) INCLUDE ([ACT_ID])    
GO   

--Extended properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ID of the transfer request act and reference key to the ACT table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'ACT_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to war era concept.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'ERA_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to the facility where the patient resides.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'FACILITY_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the vista site.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'VISTA_SITE_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient''s diagnosis.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'DIAGNOSIS'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Destination of the transfer.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'CURRENT_LOCATION'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Transfer request comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'COMMENTS'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to the contract concept associated with the patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'CONTRACT_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'FK to the Specialty concept.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'SPECIALITY_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Admission date in the current location.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'LOCATION_ADMISSION_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The region code for the facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'FACILITY_REGION'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'VISN code for the facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'FACILITY_VISN'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the transfer was requested.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'REQUESTED_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who created the transfer request.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'ENTERED_BY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who last edited the transfer request.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_BY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the transfer request was edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'EDITED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User ID of user when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Datetime when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'CREATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User ID of user when record was updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Datetime when record was changed(updated).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'True/false flag for national waiting list.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ', @level2type=N'COLUMN',@level2name=N'IS_NATIONAL_WAIT_LIST'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Transfer request table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TRANSFER_REQ'
GO